
//var ARFC_pool = new Array();
var ARFC_lastError = '';
var ARFC_base64KeyStr = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
var undefined;

function showProperties(prefix, obj) {
	var str = '';
	for (var p in obj)
		str += p + ' ';
	alert(prefix + str);
}

function ARFC_trim(str) {
	return str.replace(/^\s*|\s*$/g,"");
}

function ARFC_getObjectInner(obj, innerTagName, innerTagAttribute) {
	var ret = {};
	for (var i = 0; i < obj.childNodes.length; i++) {
		var child = obj.childNodes[i];
		if (child.nodeType != 1)
			continue;
		if (child.tagName != innerTagName)
			continue;
		var attributeName = child.getAttribute(innerTagAttribute);
		if (child.childNodes.length > 0) {
			var j = 0;
			while (child.childNodes[j].nodeType != 1)
				j++;
			ret[attributeName] = ARFC_getDataInner(child.childNodes[j]);
		}
	}
	return ret;
}

function ARFC_getDataInner(obj) {
	if (obj.tagName == 'array') {
		if (obj.getAttribute('associative')) {
			return ARFC_getObjectInner(obj, 'element', 'index');
		}
		else {
			var ret = new Array();
			var index = 0;
			for (var i = 0; i < obj.childNodes.length; i++) {
				var child = obj.childNodes[i];
				if (child.nodeType != 1)
					continue;
				if (child.tagName != 'element')
					continue;
				var attributeName = child.getAttribute('index');
				if (child.childNodes.length > 0) {
					var j = 0;
					while (child.childNodes[j].nodeType != 1)
						j++;
					ret[index] = ARFC_getDataInner(child.childNodes[j]);
					index++;
				}
			}
			return ret;
		}
	}
	else if (obj.tagName == 'object') {
		return ARFC_getObjectInner(obj, 'attribute', 'name');
	}
	else if (obj.tagName == 'string') {
		var at = obj.getAttribute('value');
		if (at == '')
			return '';
		return ARFC_decode64(at);
	}
	else if (obj.tagName == 'number') {
		var vi = parseInt(obj.getAttribute('value'), 10);
		var vf = parseFloat(obj.getAttribute('value'), 10);
		if (vf != parseFloat(vi, 10))
			return vf;
		else
			return vi;
	}
	else if (obj.tagName == 'boolean') {
		var booleanStr = obj.getAttribute('value');
		if (booleanStr == 'true')
			return true;
		else
			return false;
	}
	else if (obj.tagName == 'null') {
		return null;
	}
	else {
		alert('Unrecognized tag \'' + obj.tagName + '\'');
	}
}


function ARFC_getData(request) {
	// var root = request.responseXML;
	//alert(request.responseText);
	var root = request.responseXML.documentElement;
	// alert('ARFC_getData(): ' + this.getDOMTree(root));
	var errorObjs = root.getElementsByTagName('error');
	if (errorObjs.length > 0) {
		ARFC_lastError = errorObjs[0].getAttribute('text');
		return null;
	}
	else {
		if (root.childNodes.length > 0) {
			var i = 0;
			while (root.childNodes[i].nodeType != 1)
				i++;
			return ARFC_getDataInner(root.childNodes[i]);
		}
		else {
			ARFC_lastError = 'Invalid function return';
			return null;
		}
	}
}

function ARFC_getDOMTree(obj) {
	var str = '';
	if (obj.childNodes.length != 0) {
		str = '<ol>';
		for (var i = 0; i < obj.childNodes.length; i++) {
			var child = obj.childNodes[i];
			if (child.nodeType == 1) {
				var strAttr = '';
				for (var j = 0; j < child.attributes.length; j++)
					strAttr += ' ' + child.attributes[j].nodeName.toLowerCase() + '="' + child.attributes[j].nodeValue + '"';
				str += '<li>' + child.tagName + strAttr + '</li>';
				str += ARFC_getDOMTree(child);
			}
			else if (child.nodeType == 3) {
				if (child.nodeValue) {
					var strAux = ARFC_trim(child.nodeValue);
					if (strAux != '')
						str += '<li> (' + child.nodeValue + ')</li>';
				}
			}
		}
		str += '</ol>';
	}
	return str;
}

function ARFC_createParameter(x) {
	var ret = '';
	if (x == null) {
		return 'null';
	}
	else if (x == undefined) {
		return 'null';
	}
	else if (typeof(x) == 'object') {
		if (x instanceof Array) {
			// ARRAY
			ret += '(';
			var first = true;
			for (var i = 0; i < x.length; i++) {
				if (typeof(x[i]) != 'function') {
					if (first)
						first = false;
					else
						ret += ',';
					ret += ARFC_createParameter(x[i]);
				}
			}
			ret += ')';
			return ret;
		}
		else {
			// OBJECT
			ret += '{';
			var first = true;
			for (var i in x) {
				if (typeof(x[i]) != 'function') {
					if (first)
						first = false;
					else
						ret += ',';
					ret += i + ':' + ARFC_createParameter(x[i]);
				}
			}
			ret += '}';
			return ret;
		}
	}
	else if (typeof(x) == 'number') {
		// NUMBER
		return x;
	}
	else if (typeof(x) == 'string') {
		// STRING
		if (x == '')
			return '\'\'';
		else
			return '\'' + ARFC_encode64(x + '') + '\'';
	}
	else if (typeof(x) == 'boolean') {
		// BOOLEAN
		return (x) ? 'true' : 'false';
	}
	else {
		// ANY ELSE (function, undefined, etc)
		return 'null';
	}
}

function ARFC_encode64(input) {
	var output = '';
	var chr1, chr2, chr3;
	var enc1, enc2, enc3, enc4;
	var i = 0;
	do {
		chr1 = input.charCodeAt(i++);
		chr2 = input.charCodeAt(i++);
		chr3 = input.charCodeAt(i++);
		enc1 = chr1 >> 2;
		enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
		enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
		enc4 = chr3 & 63;
		if (isNaN(chr2))
			enc3 = enc4 = 64;
		else if (isNaN(chr3))
			enc4 = 64;
		output = output + ARFC_base64KeyStr.charAt(enc1) + ARFC_base64KeyStr.charAt(enc2) + ARFC_base64KeyStr.charAt(enc3) + ARFC_base64KeyStr.charAt(enc4);
	} while (i < input.length);
	return output;
}

function ARFC_decode64(input) {
	var output = '';
	var chr1, chr2, chr3;
	var enc1, enc2, enc3, enc4;
	var i = 0;
	// remove all characters that are not A-Z, a-z, 0-9, +, / or =
	input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
	do {
		enc1 = ARFC_base64KeyStr.indexOf(input.charAt(i++));
		enc2 = ARFC_base64KeyStr.indexOf(input.charAt(i++));
		enc3 = ARFC_base64KeyStr.indexOf(input.charAt(i++));
		enc4 = ARFC_base64KeyStr.indexOf(input.charAt(i++));
		chr1 = (enc1 << 2) | (enc2 >> 4);
		chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
		chr3 = ((enc3 & 3) << 6) | enc4;
		output = output + String.fromCharCode(chr1);
		if (enc3 != 64)
			output = output + String.fromCharCode(chr2);
		if (enc4 != 64)
			output = output + String.fromCharCode(chr3);
	} while (i < input.length);
	return output;
}

function ARFC_getXMLHttpRequestObject() {
	var ret = null;
	if (window.XMLHttpRequest) {
		// W3C
		ret = new XMLHttpRequest();
	}
	else if (window.ActiveXObject) {
		// IE
		try {
			ret = new ActiveXObject('Msxml2.XMLHTTP');
		} catch (e1) {
			try {
				ret = new ActiveXObject('Microsoft.XMLHTTP');
			} catch (e2) {
				ret = null;
			}
		}
	}
	return ret;
}

/*
function ARFC_removeMarkedRequests() {
	var temp = new Array();
	var j = 0;
	for (var i = 0; i < ARFC_pool.length; i++) {
		if (ARFC_pool[i].removeMe)
			continue;
		temp[j] = ARFC_pool[i];
		j++;
	}
	ARFC_pool = temp;
}

function ARFC_readyStateChanged() {
	for (var i = 0; i < ARFC_pool.length; i++) {
		var request = ARFC_pool[i].request;
		var obj = ARFC_pool[i].callbackObj;
		var method = ARFC_pool[i].callbackMethod;
		var userData = ARFC_pool[i].userData;
		var debugId = ARFC_pool[i].debugId;
		if ((request.readyState == 4) && !ARFC_pool[i].removeMe) {
			ARFC_pool[i].removeMe = true;
			var returnValue = null;
			if ((request.status == 200) || (request.status == 0)) {
				returnValue = ARFC_getData(request);
				if (debugId != null)
					document.getElementById(debugId).innerHTML = ARFC_getDOMTree(request.responseXML);
			}
			method.call(obj, returnValue, request.status, userData);
			delete ARFC_pool[i].request;
		}
	}
	ARFC_removeMarkedRequests();
}

function ARFC_call(functionName, param, obj, callbackMethod, userData) {
	var postStr = 'function=' + functionName;
	if (param != undefined) {
		var paramStr = ARFC_createParameter(param);
		postStr += '&parameters=' + ARFC_encode64(paramStr + '');
	}
	var req = ARFC_getXMLHttpRequestObject();
	showProperties('XMLHttpRequest: ', req);
	req.open('POST', 'arfc.xml.php', true);
	req.onreadystatechange = ARFC_readyStateChanged;
	var debugId = null;
	if (arguments.length > 5)
		debugId = arguments[5];
	var r = {request:req, callbackObj:obj, callbackMethod:callbackMethod, userData:userData, removeMe:false, debugId:debugId}
	ARFC_pool[ARFC_pool.length] = r;
	req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	req.send(postStr);
}
*/


var ARFC_current = null;
var ARFC_pendingQueue = new Array();
var ARFC_timeoutHandle = null;

function ARFC_pendingQueuePush(data) {
	ARFC_pendingQueue[ARFC_pendingQueue.length] = data;
}

function ARFC_pendingQueuePop() {
	if (ARFC_pendingQueue.length == 0)
		return null;
	var ret = ARFC_pendingQueue[0];
	var aux = new Array();
	for (var i = 1; i < ARFC_pendingQueue.length; i++)
		aux[i - 1] = ARFC_pendingQueue[i];
	ARFC_pendingQueue = aux;
	return ret;
}

function ARFC_getNewRequest() {
	var req = ARFC_getXMLHttpRequestObject();
	if (req == null)
		alert('NULL');
	var slashIndex = document.location.href.lastIndexOf('/');
	var url = document.location.href.substring(0, slashIndex) + '/arfc.xml.php';
	req.open('POST', url, true);
	req.onreadystatechange = ARFC_readyStateChanged;
	//req.onload = ARFC_readyStateChanged;
	req.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
	return req;
}

function ARFC_launchCurrent() {
	if (ARFC_timeoutHandle != null) {
		clearTimeout(ARFC_timeoutHandle);
		ARFC_timeoutHandle = null;
	}
	if (ARFC_current == null)
		return;
	ARFC_current.request = ARFC_getNewRequest();
	ARFC_current.request.send(ARFC_current.postStr);
	//console.log('request sent: postStr=' + ARFC_current.postStr);
	//ARFC_current.timeoutHandle = setTimeout(function() { ARFC_current.request.abort(); }, 100000);
}

function ARFC_readyStateChanged() {
	if (ARFC_current == null)
		return;
	if (ARFC_current.request.readyState == 4) {
		var returnValue = null;
		try {
			var auxStatus = ARFC_current.request.status;
		}
		catch (ex) {
			ARFC_current.request.abort();
			ARFC_timeoutHandle = setTimeout('ARFC_launchCurrent()', 100);
			return;
		}
		if (ARFC_current.request.status == 200) {
			ARFC_lastError = '';
			returnValue = ARFC_getData(ARFC_current.request);
			if (ARFC_lastError != '')
				alert('ARFC_lastError: ' + ARFC_lastError);
			if (ARFC_current.debugId != null)
				document.getElementById(ARFC_current.debugId).innerHTML = ARFC_getDOMTree(ARFC_current.request.responseXML);
		}
		if ((ARFC_current.callbackMethod != null) && (ARFC_current.callbackObj != null))
			ARFC_current.callbackMethod.call(ARFC_current.callbackObj, returnValue, ARFC_current.request.status, ARFC_current.userData);
		ARFC_current.request = null;
		delete ARFC_current.request;
		delete ARFC_current;
		ARFC_current = ARFC_pendingQueuePop();
		if (ARFC_current != null)
			ARFC_timeoutHandle = setTimeout('ARFC_launchCurrent()', 100);
	}
}

function ARFC_call(functionName, param, obj, callbackMethod, userData) {
	var postStr = 'function=' + functionName;
	if (param != undefined) {
		var paramStr = ARFC_createParameter(param);
		postStr += '&parameters=' + ARFC_encode64(paramStr + '').replace(/=/g, '%3D').replace(/\+/g, '%2B').replace(/\//g, '%2F');
	}
	var debugId = null;
	if (arguments.length > 5)
		debugId = arguments[5];
	var r = {request:null, postStr:postStr, callbackObj:obj, callbackMethod:callbackMethod, userData:userData, debugId:debugId, timeoutHandle:null};
	if (ARFC_current == null) {
		ARFC_current = r;
		ARFC_pendingQueue = new Array();
		ARFC_launchCurrent();
	}
	else
		ARFC_pendingQueuePush(r);
}

