<?php
	session_start();
	header("Content-Type: text/xml;charset=iso-8859-1");


	/*
	class MiClase {
		var $pepe;
		var $juan;
	}

	function PHPRFC_ejemplo1($v) {
		$v->campo1++;
		$v->campo2--;
		return $v;
	}

	function PHPRFC_una_funcion() {
		$ret = array();
		$ret[] = "Avelino";
		$ret[] = "Herrera";
		$aux = new MiClase();
		$aux->pepe = 35;
		$aux->juan = "Antonio";
		$ret[] = $aux;
		$aux2 = array();
		$aux2["primero"] = 999;
		$aux2["segundo"] = 56.7;
		$aux2["tercero"] = false;
		$aux2["cuarto"] = true;
		$ret[] = $aux2;
		return $ret;
	}

	function PHPRFC_otra_funcion() {
		$aux = new MiClase();
		$aux->pepe = 35;
		$aux->juan = "Antonio";
		return $aux;
	}

	function PHPRFC_y_otra_mas() {
		return 67;
	}

	function PHPRFC_identidad($par) {
		return $par;
	}
	*/

	function loadAllARFC() {
		foreach (glob("ARFC_*.php") as $archivo) 
			require_once($archivo);
	}

	loadAllARFC();


	$TOKEN_END = 0;
	$TOKEN_LEFT_PAR = 1;
	$TOKEN_RIGHT_PAR = 2;
	$TOKEN_LEFT_KEY = 3;
	$TOKEN_RIGHT_KEY = 4;
	$TOKEN_COMMA = 5;
	$TOKEN_COLON = 6;
	$TOKEN_VALUE_STRING = 7;
	$TOKEN_VALUE_NUMBER = 8;
	$TOKEN_VALUE_BOOLEAN = 9;
	$TOKEN_VALUE_NULL = 10;
	$TOKEN_ID = 11;
	$TOKEN_NAMES = array("END", "LEFT_PAR", "RIGHT_PAR", "LEFT_KEY", "RIGHT_KEY", "COMMA", "COLON", "VALUE_STRING", "VALUE_NUMBER", "VALUE_BOOLEAN", "TOKEN_VALUE_NULL", "ID");

	class Token {
		var $type;  // $TOKEN_LEFT_PAR, $TOKEN_RIGHT_PAR, $TOKEN_LEFT_KEY...
		var $value;
	}


	class ParametersParser {
		var $input;
		var $inputPointer;
		var $isLookAhead;
		var $tempNumber;
		var $codeString;

		function ParametersParser($input) {
			$this->input = $input;
			$this->inputPointer = 0;
			$this->isLookAhead = false;
			$this->tempNumber = 1;
			$this->codeString = "";
		}

		function getTempVariable() {
			$ret = "\$parser_temp".$this->tempNumber;
			$this->tempNumber++;
			return $ret;
		}

		function isNumber($v) {
			return preg_match("/^[\-0-9\.]/", $v);
		}

		function showToken(&$t) {
			global $TOKEN_END, $TOKEN_LEFT_PAR, $TOKEN_RIGHT_PAR, $TOKEN_LEFT_KEY, $TOKEN_RIGHT_KEY, $TOKEN_COMMA, $TOKEN_COLON, $TOKEN_VALUE_STRING, $TOKEN_VALUE_NUMBER, $TOKEN_VALUE_BOOLEAN, $TOKEN_VALUE_NULL, $TOKEN_ID;
			global $TOKEN_NAMES;
			echo "Token: ".$TOKEN_NAMES[$t->type]." = '".$t->value."'<br/>\n";
		}

		function getLookAhead() {
			$this->isLookAhead = true;
			$ret = $this->getToken();
			$this->isLookAhead = false;
			return $ret;
		}

		// Lexycal analizer
		function getToken() {
			global $TOKEN_END, $TOKEN_LEFT_PAR, $TOKEN_RIGHT_PAR, $TOKEN_LEFT_KEY, $TOKEN_RIGHT_KEY, $TOKEN_COMMA, $TOKEN_COLON, $TOKEN_VALUE_STRING, $TOKEN_VALUE_NUMBER, $TOKEN_VALUE_BOOLEAN, $TOKEN_VALUE_NULL, $TOKEN_ID;
			$ret = new Token();
			$pointer = $this->inputPointer;
			if (strlen($this->input) <= $pointer) {
				// echo "END<br/>\n";
				$ret->type = $TOKEN_END;
			}
			else if ($this->input[$pointer] == "'") {
				// echo "STRING<br/>\n";
				$pointer++;
				$str = "";
				for ( ; ((strlen($this->input) > $pointer) && ($this->input[$pointer] != "'")); $pointer++)
					$str .= $this->input[$pointer];
				$pointer++;
				$ret->type = $TOKEN_VALUE_STRING;
				//$ret->value = base64_decode($str);
				$ret->value = str_replace("\"", "\\\"", base64_decode($str));
			}
			else if ($this->isNumber($this->input[$pointer])) {
				// echo "NUMBER<br/>\n";
				$str = "";
				for ( ; ((strlen($this->input) > $pointer) && ($this->isNumber($this->input[$pointer]))); $pointer++)
					$str .= $this->input[$pointer];
				$ret->type = $TOKEN_VALUE_NUMBER;
				$ret->value = $str * 1;
			}
			else if (substr($this->input, $pointer, 4) == "true") {
				// echo "BOOLEAN<br/>\n";
				$ret->type = $TOKEN_VALUE_BOOLEAN;
				$ret->value = true;
				$pointer += 4;
			}
			else if (substr($this->input, $pointer, 5) == "false") {
				// echo "BOOLEAN<br/>\n";
				$ret->type = $TOKEN_VALUE_BOOLEAN;
				$ret->value = false;
				$pointer += 5;
			}
			else if (substr($this->input, $pointer, 4) == "null") {
				// echo "BOOLEAN<br/>\n";
				$ret->type = $TOKEN_VALUE_NULL;
				$pointer += 4;
			}
			else if ($this->input[$pointer] == "(") {
				// echo "LEFT_PAR<br/>\n";
				$ret->type = $TOKEN_LEFT_PAR;
				$pointer++;
			}
			else if ($this->input[$pointer] == ")") {
				// echo "RIGHT_PAR<br/>\n";
				$ret->type = $TOKEN_RIGHT_PAR;
				$pointer++;
			}
			else if ($this->input[$pointer] == "{") {
				// echo "LEFT_KEY<br/>\n";
				$ret->type = $TOKEN_LEFT_KEY;
				$pointer++;
			}
			else if ($this->input[$pointer] == "}") {
				// echo "RIGHT_KEY<br/>\n";
				$ret->type = $TOKEN_RIGHT_KEY;
				$pointer++;
			}
			else if ($this->input[$pointer] == ":") {
				// echo "COLON<br/>\n";
				$ret->type = $TOKEN_COLON;
				$pointer++;
			}
			else if ($this->input[$pointer] == ",") {
				// echo "COMMA<br/>\n";
				$ret->type = $TOKEN_COMMA;
				$pointer++;
			}
			else {
				// echo "ID<br/>\n";
				preg_match("/^[a-zA-Z0-9\"\']+/", substr($this->input, $this->inputPointer), $matches);
				$ret->type = $TOKEN_ID;
				$ret->value = $matches[0];
				// echo "::::::: ".$ret->value."\n";
				$pointer += strlen($matches[0]);
			}
			if (!$this->isLookAhead)
				$this->inputPointer = $pointer;
			return $ret;
		}

		// Syntactic analizer
		function parseExpression() {
			global $TOKEN_VALUE_STRING, $TOKEN_VALUE_NUMBER, $TOKEN_VALUE_BOOLEAN, $TOKEN_VALUE_NULL, $TOKEN_LEFT_PAR, $TOKEN_LEFT_KEY;
			$ret = "";
			$la = $this->getLookAhead();
			if (($la->type == $TOKEN_VALUE_STRING) || ($la->type == $TOKEN_VALUE_NUMBER) || ($la->type == $TOKEN_VALUE_BOOLEAN) || ($la->type == $TOKEN_VALUE_NULL))
				$ret = $this->parseValue();
			else if ($la->type == $TOKEN_LEFT_PAR) {
				$this->getToken();

				$temp = $this->getTempVariable();
				$this->codeString .= $temp." = array();\n";
				$this->parseArrayList($temp);
				$ret = $temp;

				$this->getToken();
			}
			else if ($la->type == $TOKEN_LEFT_KEY) {
				$this->getToken();

				$temp = $this->getTempVariable();
				$this->codeString .= $temp." = new stdclass;\n";
				$this->parseAttributeList($temp);
				$ret = $temp;

				$this->getToken();
			}
			else
				$ret = "UNDEFINED";
			return $ret;
		}

		function parseValue() {
			global $TOKEN_VALUE_STRING, $TOKEN_VALUE_NUMBER, $TOKEN_VALUE_BOOLEAN, $TOKEN_VALUE_NULL;
			$la = $this->getLookAhead();
			$t = $this->getToken();
			if ($la->type == $TOKEN_VALUE_STRING)
				return "\"".$t->value."\"";
			else if ($la->type == $TOKEN_VALUE_NUMBER)
				return $t->value;
			else if ($la->type == $TOKEN_VALUE_BOOLEAN)
				return ($t->value) ? "true" : "false";
			else if ($la->type == $TOKEN_VALUE_NULL)
				return "null";
			else
				return "UNDEFINED";
		}

		function parseArrayList($arrayTemp) {
			global $TOKEN_COMMA;
			$temp = $this->parseExpression();
			$this->codeString .= $arrayTemp."[] = ".$temp.";\n";
			$la = $this->getLookAhead();
			if ($la->type == $TOKEN_COMMA) {
				$this->getToken();
				$this->parseArrayList($arrayTemp);
			}
		}

		function parseAttributeList($objectTemp) {
			global $TOKEN_COMMA;

			$t = $this->getToken();
			$this->getToken();
			$temp = $this->parseExpression();
			$this->codeString .= $objectTemp."->".$t->value." = ".$temp.";\n";

			$la = $this->getLookAhead();
			if ($la->type == $TOKEN_COMMA) {
				$this->getToken();
				$this->parseAttributeList($objectTemp);
			}
		}

		/*
		function parseExpression() {
			global $TOKEN_VALUE_STRING, $TOKEN_VALUE_NUMBER, $TOKEN_VALUE_BOOLEAN, $TOKEN_LEFT_PAR, $TOKEN_LEFT_KEY;
			$ret = "";
			$la = $this->getLookAhead();
			if (($la->type == $TOKEN_VALUE_STRING) || ($la->type == $TOKEN_VALUE_NUMBER) || ($la->type == $TOKEN_VALUE_BOOLEAN))
				$ret = $this->parseValue();
			else if ($la->type == $TOKEN_LEFT_PAR) {
				$this->getToken();
				$ret = "(".$this->parseArrayList().")";
				$this->getToken();
			}
			else if ($la->type == $TOKEN_LEFT_KEY) {
				$this->getToken();
				$ret = "{".$this->parseAttributeList()."}";
				$this->getToken();
			}
			else
				$ret = "UNDEFINED";
			return $ret;
		}

		function parseValue() {
			global $TOKEN_VALUE_STRING, $TOKEN_VALUE_NUMBER, $TOKEN_VALUE_BOOLEAN;
			$la = $this->getLookAhead();
			$t = $this->getToken();
			if ($la->type == $TOKEN_VALUE_STRING)
				return "'".$t->value."'";
			else if ($la->type == $TOKEN_VALUE_NUMBER)
				return $t->value;
			else if ($la->type == $TOKEN_VALUE_BOOLEAN)
				return ($t->value) ? "true" : "false";
			else
				return "UNDEFINED";
		}

		function parseArrayList() {
			global $TOKEN_COMMA;
			$ret = $this->parseExpression();
			$la = $this->getLookAhead();
			if ($la->type == $TOKEN_COMMA) {
				$this->getToken();
				$ret .= ", ".$this->parseArrayList();
			}
			return $ret;
		}

		function parseAttribute() {
			$t = $this->getToken();
			$ret = $t->value;
			$this->getToken();
			$ret .= ": ".$this->parseExpression();
			return $ret;
		}

		function parseAttributeList() {
			global $TOKEN_COMMA;
			$ret = $this->parseAttribute();
			$la = $this->getLookAhead();
			if ($la->type == $TOKEN_COMMA) {
				$this->getToken();
				$ret .= ", ".$this->parseAttributeList();
			}
			return $ret;
		}
		*/
	}


	function tabulate($amount) {
		$ret = "";
		for ($i = 0; $i < $amount; $i++)
			$ret .= "\t";
		return $ret;
	}


	function is_assoc_array(&$v) {
		if (!is_array($v))
			return false;
		$keys = array_keys($v);
		$n = count($keys);
		$assoc = false;
		for ($i = 0; $i < $n; $i++) {
			$key = $keys[$i];
			//if ($key != $i)
			if (strcmp($key."", $i."") != 0) {
				$assoc = true;
				break;
			}
		}
		return $assoc;
	}


	function generateXML($tab, &$variable) {
		$ret = "";
		$tabStr = tabulate($tab);
		$tabStr2 = tabulate($tab + 1);
		if (is_array($variable)) {
			$ret .= $tabStr;
			if (is_assoc_array($variable))
				$ret .= "<array associative=\"true\">\n";
			else
				$ret .= "<array>\n";
			$indices = array_keys($variable);
			$n = count($indices);
			for ($i = 0; $i < $n; $i++) {
				$index = $indices[$i];
				$contenido = $variable[$index];
				$ret .= $tabStr2;
				$ret .= "<element index=\"".$index."\">\n";
				$ret .= generateXML($tab + 2, $variable[$index]);
				$ret .= $tabStr2;
				$ret .= "</element>\n";
			}
			$ret .= $tabStr;
			$ret .= "</array>\n";
		}
		else if (is_object($variable)) {
			$ret .= $tabStr;
			$className = get_class($variable);
			$ret .= "<object class=\"".$className."\">\n";
			$attributes = get_object_vars($variable);
			$attributeNames = array_keys($attributes);
			$n = count($attributeNames);
			for ($i = 0; $i < $n; $i++) {
				$currName = $attributeNames[$i];
				$currValue = $attributes[$currName];
				$ret .= $tabStr2;
				$ret .= "<attribute name=\"".$currName."\">\n";
				$ret .= generateXML($tab + 2, $currValue);
				$ret .= $tabStr2;
				$ret .= "</attribute>\n";
			}
			$ret .= $tabStr;
			$ret .= "</object>\n";
		}
		else if (is_scalar($variable)) {
			$ret .= $tabStr;
			if (is_string($variable)) {
				$ret .= "<string value=\"".base64_encode($variable)."\"/>\n";
			}
			else if (is_bool($variable))
				$ret .= "<boolean value=\"".(($variable) ? "true" : "false")."\"/>\n";
			else
				$ret .= "<number value=\"".$variable."\"/>\n";
		}
		else if ($variable == null) {
			$ret .= $tabStr;
			$ret .= "<null/>\n";
		}
		else {
			$ret .= $tabStr;
			$ret .= "<error text=\"Invalid type '".gettype($variable)."'\"/>\n";
		}
		return $ret;
	}



	//$SCRIPT_PARAMETERS =& $HTTP_POST_VARS;
	$SCRIPT_PARAMETERS =& $_POST;
	//echo "<result>\n";
	if (array_key_exists("function", $SCRIPT_PARAMETERS)) {
		$functionParameters = null;
		$realParameter = null;
		if (array_key_exists("parameters", $SCRIPT_PARAMETERS)) {
			$functionParameters = base64_decode($SCRIPT_PARAMETERS["parameters"]);
			//echo "\t<parameters value=\"".$functionParameters."\"/>\n";
			$p = new ParametersParser($functionParameters);
			$temp = $p->parseExpression();
			// echo ":::::: ".$p->codeString."\n";
			/*
			echo "<pre>\n".$p->codeString."</pre>\n";
			echo "<temp name=\"".$temp."\"/>\n";
			*/
			error_reporting(0);
			//echo "CODE STRING='".$p->codeString."'   TEMP='".$temp."'";
			if ($p->codeString != "")
				eval($p->codeString);
			if ($temp != "UNDEFINED") {
				eval("\$realParameter = ".$temp.";");
			}
			// print_r($realParameter);
			error_reporting(E_ALL);
		}
		$functionName = $SCRIPT_PARAMETERS["function"];
		if (function_exists("ARFC_".$functionName)) {
			$ret = null;
			if ($realParameter == null) {
				$ret = call_user_func("ARFC_".$functionName);
			}
			else {
				eval("\$ret = ARFC_".$functionName."(\$realParameter);");
			}
			/*
			echo "-----\n";
			print_r($ret);
			echo "-----\n";
			*/
			echo "<result>\n".generateXML(1, $ret);
		}
		else
			echo "<result>\n\t<error text=\"'".$functionName."' not defined\"/>\n";
	}
	else
		echo "<result>\n\t<error text=\"No function name provided\"/>\n";
	echo "</result>\n";
?>
