
#ifndef  __FFT_H__
#define  __FFT_H__

/*
	FFT implementation
	(c) 2006  Avelino Herrera Morales
	avelinoherrera@hotpop.com
	http://avelino.gabiot.com/blog

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

*/

typedef struct {
	float re, im;
	} complex;

void complex_add(complex *result, complex *x, complex *y);
void complex_sub(complex *result, complex *x, complex *y);
void complex_mul(complex *result, complex *x, complex *y);
void complex_mul_scalar(complex *result, float v);
void complex_pow(complex *result, complex *base, int exponent);
float complex_abs(complex *v);
void do_fft(complex *x, int ln, int inverse);

void fft(complex *x, int ln);
void ifft(complex *x, int ln);

int xlog2(int n);
void fill_hanning_window(float *w, int n);

#endif   /* __FFT_H__ */
