/*
	Pequea utilidad para oir ficheros RAW: ./listen < fichero.raw
	(16 bits, little-endian, 44100 Hz y estreo)

	Avelino Herrera Morales
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/soundcard.h>

#define  MAX  512


/*  Variables relacionadas con /dev/dsp. */
int dev_fd;
int format = AFMT_S16_LE;
int stereo = 1;                /*  Estreo. */
int sample_rate = 44100;       /*  44.1 KHz. */

/*  Variables relacionadas con el fichero de sonido. */
int source_fd;
signed short int temp_buffer[MAX];
int size;


int main(int argc, char *argv[]) {
	/*  Abrimos /dev/dsp en modo de escritura. */
	dev_fd = open("/dev/dsp", O_WRONLY, 0);
	if (dev_fd < 0) {
		perror("opening /dev/dsp");
		return -1;
		}

	/*  Ajustamos los parmetros de la reproduccin. */
	ioctl(dev_fd, SNDCTL_DSP_SETFMT, &format);
	ioctl(dev_fd, SNDCTL_DSP_STEREO, &stereo);
	ioctl(dev_fd, SNDCTL_DSP_SPEED, &sample_rate);

	/*  Reproducimos la entrada estndar. */
	while (1) {
		size = read(0, temp_buffer, MAX * sizeof(signed short int));
		write(dev_fd, temp_buffer, size);
		if (size < (MAX * sizeof(signed short int)))
			break;
		}

	/*  Cerramos /dev/dsp. */
	close(dev_fd);
	return 0;
	}
