

#ifndef  __INTERRUPT_H__
#define  __INTERRUPT_H__


#include <cstdint>


#define  PFIC_IENR                ((uint32_t *) 0xE000E100)
#define  PFIC_ENABLE(irq)         PFIC_IENR[(irq) >> 5] |= (((uint32_t) 1) << ((irq) & 0x1F))


#define  SYSTICK_INT             12
#define  SYSTICK_INT_SECTION     ".pfic_int_systick"


extern "C++" {
	namespace avelino {
		void interrupt_init();
	}
}


/*

	void f() __attribute__ ((interrupt, section(SYSTICK_INT_SECTION)));

	void f() {
		//
		// ... if (PFIC_IS_PENDING(SYSTICK_INT)) ...
		//
		PFIC_CLEAR(SYSTICK_INT);
	}

...
interrupt_init();
//
// ... configure systick timer ...
//
PFIC_IE(SYSTICK_INT);
while (true)
	asm volatile ("wfi");
...
*/


#endif  // __INTERRUPT_H__
