/*
	Librera para salida de audio en Linux

	(c) 2005 Avelino Herrera Morales
																																		 
	This software is free software; you can redistribute it and/or modify
	it under the terms of the GNU  General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
																																																																				   
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU  General Public License for more details.
																																																																				   
	You should have received a copy of the GNU  General Public
	License along with this software; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
*/

#include <math.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <sys/soundcard.h>

#include "audio.h"


int log2i(int x) {
	return (int) rint(log((double) x) / log(2.0));
	}

int audio_open(int stereo) {
	int format = AFMT_S16_LE;
	int sample_rate = SAMPLE_RATE;
	int setting = 0x00040000;
	int f;

	if ((f = open("/dev/dsp", O_WRONLY, 0)) == -1) {
		perror("audio_open");
		exit(-1);
		}
	setting |= log2i(BUFFER_SIZE * sizeof(signed short int) * 2);
	ioctl(f, SNDCTL_DSP_SETFRAGMENT, &setting);
	ioctl(f, SNDCTL_DSP_SETFMT, &format);
	ioctl(f, SNDCTL_DSP_STEREO, &stereo);
	ioctl(f, SNDCTL_DSP_SPEED, &sample_rate);
	return f;
	}

void audio_play_mono(int fd, float *output) {
	signed short int p[BUFFER_SIZE];
	int i;
	register int temp;

	for (i = 0; i < BUFFER_SIZE; i++) {
		temp = (int) rint(output[i] * 32767);
		if (temp > 32767)
			p[i] = 32767;
		else if (temp < -32768)
			p[i] = -32768;
		else
			p[i] = (signed short int) temp;
		}
	write(fd, p, BUFFER_SIZE * sizeof(signed short int));
	return;
	}

void audio_play_stereo(int fd, float *left_output, float *right_output) {
	signed short int p[BUFFER_SIZE * 2];
	int i;
	register int temp;

	for (i = 0; i < BUFFER_SIZE; i++) {
		temp = (int) rint(left_output[i] * 32767);
		if (temp > 32767)
			p[i * 2] = 32767;
		else if (temp < -32768)
			p[i * 2] = -32768;
		else
			p[i * 2] = (signed short int) temp;
		temp = (int) rint(right_output[i] * 32767);
		if (temp > 32767)
			p[i * 2 + 1] = 32767;
		else if (temp < -32768)
			p[i * 2 + 1] = -32768;
		else
			p[i * 2 + 1] = (signed short int) temp;
		}
	write(fd, p, BUFFER_SIZE * sizeof(signed short int) * 2);
	return;
	}
