/*
	Librera para acceso a audio en Linux

	(c) Avelino Herrera Morales

	This software is free software; you can redistribute it and/or modify
	it under the terms of the GNU  General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
																																																																				   
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU  General Public License for more details.
																																																																				   
	You should have received a copy of the GNU  General Public
	License along with this software; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
*/

#ifndef  __AUDIO_H__
#define  __AUDIO_H__

#define  SAMPLE_RATE  44100
#define  BUFFER_SIZE  512

/* abre el dispositivo de sonido /dev/dsp: 16 bits con signo y a 44.1Khz. Si el
   parmetro vale 1, se abre en modo estreo, si vale 0 en modo mono. Devuelve
   el handle de fichero */
int audio_open(int stereo);

/* enva BUFFER_SIZE muestras desde el buffer output al dispositivo fd */
void audio_play_mono(int fd, float *output);

/* enva BUFFER_SIZE * 2 muestras de audio al dispositivo de salida fd de los
   buffers left_output (BUFFER_SIZE muestras) y right_output (BUFFER_SIZE
   muestras) */
void audio_play_stereo(int fd, float *left_output, float *right_output);

#endif  /* __AUDIO_H__ */
