/*
 * (c) Avelino Herrera Morales
 *
 * Generador de onda senoidal basado en una tabla precalculada.
 *
	This software is free software; you can redistribute it and/or modify
	it under the terms of the GNU  General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
																																																																				   
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU  General Public License for more details.
																																																																				   
	You should have received a copy of the GNU  General Public
	License along with this software; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include "audio.h"

#define  F_MUEST        44100  /* frecuencia de muestreo: 44.1 KHz */
#define  F_SENIAL       440    /* un LA en la 4 octava del piano */
#define  TAM_TABLA      2048   /* tamao de la tabla precalculada de onda */
#define  TIEMPO         2      /* 2 segundos de reproduccin */

#define  MUESTRAS_TOTALES  (TIEMPO * F_MUEST)

float tabla_coseno[TAM_TABLA];
signed short int salida[MUESTRAS_TOTALES];

int main(void) {
	int i;
	int fd;
	float v, inc, t;

	fd = audio_open(0);
	/* precalculamos la tabla con el coseno */
	for (i = 0; i < TAM_TABLA; i++)
		tabla_coseno[i] = cos(2 * M_PI * (float)i / TAM_TABLA);
	/* calculamos el incremento para la tabla */
	inc = (float)(TAM_TABLA * F_SENIAL) / F_MUEST;
	t = 0;
	for (i = 0; i < MUESTRAS_TOTALES; i++) {
		/* leemos de la tabla precalculada */
		v = tabla_coseno[(int) rint(t)];
		/* limitamos la seal por si hay desbordamiento */
		if (v > 1.0)
			v = 1.0;
		else if (v < -1.0)
			v = -1.0;
		/* escribimos en la salida */
		salida[i] = (signed short int) rint(v * 32767);
		/* nos preparamos para leer la siguiente muestra de la tabla */
		t += inc;
		/* controlamos el desbordamiento del ndice t */
		if (t >= TAM_TABLA)
			t -= TAM_TABLA;
		}
	write(fd, salida, MUESTRAS_TOTALES * sizeof(signed short int));
	return 0;
	}
