/*
 * (c) Avelino Herrera Morales
 *
 * Ejemplo de aplicacin de una envolvente en una seal.
 *
	This software is free software; you can redistribute it and/or modify
	it under the terms of the GNU  General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
																																																																				   
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU  General Public License for more details.
																																																																				   
	You should have received a copy of the GNU  General Public
	License along with this software; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <math.h>
#include "audio.h"


#define  F_SENIAL  440    /* un LA en la 4 octava del piano */
#define  F_MUEST   44100  /* frecuencia de muetreo: 44.1 KHz */
#define  TIEMPO    2      /* segundos de reproduccin */

/* valores de tiempo para la envolvente AD */
#define  TIEMPO_ATAQUE    0.01
#define  TIEMPO_CAIDA     1
#define  MUESTRAS_ATAQUE  ((int) rint(TIEMPO_ATAQUE * F_MUEST))
#define  MUESTRAS_CAIDA   ((int) rint(TIEMPO_CAIDA * F_MUEST))

#define  MUESTRAS_TOTALES  (TIEMPO * F_MUEST)

signed short int salida[MUESTRAS_TOTALES];


float e(int i) {
	if (i < MUESTRAS_ATAQUE)
		return ((float)i / MUESTRAS_ATAQUE);
	else if (i < (MUESTRAS_ATAQUE + MUESTRAS_CAIDA))
		return 1.0 - ((float)(i - MUESTRAS_ATAQUE) / MUESTRAS_CAIDA);
	else
		return 0;
	}


int main(void) {
	int i;
	int fd;
	float v;

	fd = audio_open(0);
	for (i = 0; i < MUESTRAS_TOTALES; i++) {
		v = e(i) * cos(2 * M_PI * ((float)i / F_MUEST) * F_SENIAL);
		salida[i] = (signed short int) rint(v * 32767);
		}
	write(fd, salida, MUESTRAS_TOTALES * sizeof(signed short int));
	return 0;
	}
