/*
 * (c) Avelino Herrera Morales
 *
 * Ejemplo de aplicacin de un filtro de estado variable sobre una seal de ruido blanco.
 *
	This software is free software; you can redistribute it and/or modify
	it under the terms of the GNU  General Public License as
	published by the Free Software Foundation; either version 2 of
	the License, or (at your option) any later version.
																																																																				   
	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU  General Public License for more details.
																																																																				   
	You should have received a copy of the GNU  General Public
	License along with this software; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
	02111-1307, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <unistd.h>
#include "audio.h"

#define  F_MUEST        44100  /* frecuencia de muestreo: 44.1 KHz */
#define  TIEMPO         2      /* 2 segundos de reproduccin */
#define  CORTE          0.1    /* frecuencia de corte del SVF */
#define  RESONANCIA     0.1    /* resonancia del SVF */

#define  MUESTRAS_TOTALES  (TIEMPO * F_MUEST)

signed short int salida[MUESTRAS_TOTALES];

int main(void) {
	int i;
	int fd;
	float u, v;
	float paso_alto = 0, paso_banda = 0, paso_bajo = 0;

	fd = audio_open(0);
	for (i = 0; i < MUESTRAS_TOTALES; i++) {
		/* generamos un ruido blanco (muestras aleatorias) */
		u = (2 * ((float)rand() / RAND_MAX)) - 1.0;
		/* realizamos el filtrado */
		paso_alto = u - (paso_banda * RESONANCIA) - paso_bajo;
		paso_banda += paso_alto * CORTE;
		paso_bajo += paso_banda * CORTE;
		/* seleccionamos como salida el paso-bajo */
		v = paso_bajo;
		/* limitamos la seal por si hay desbordamiento */
		if (v > 1.0)
			v = 1.0;
		else if (v < -1.0)
			v = -1.0;
		/* escribimos en la salida */
		salida[i] = (signed short int) rint(v * 32767);
		}
	write(fd, salida, MUESTRAS_TOTALES * sizeof(signed short int));
	return 0;
	}
