

#include <stdint.h>


using namespace std;


extern "C" {
	extern void (*__CTOR_LIST__)();
	extern void (*__DTOR_LIST__)();
	extern void (*__init_array_start)();
	extern void (*__init_array_end)();
	extern void (*__fini_array_start)();
	extern void (*__fini_array_end)();
}


void _callInitArray() {
	void (**f)() = &__init_array_start;
	while (f != &__init_array_end) {
		(*f)();
		f++;
	}
}


void _callConstructors() {
	void (**constructor)() = &__CTOR_LIST__;
	uint32_t total = *(uint32_t *) constructor;
	constructor++;
	while (total) {
		(*constructor)();
		total--;
		constructor++;
	}
}


void _callDestructors() {
	void (**destructor)() = &__DTOR_LIST__;
	uint32_t total = *(uint32_t *) destructor;
	destructor++;
	while (total) {
		(*destructor)();
		total--;
		destructor++;
	}
}


void _callFiniArray() {
	void (**f)() = &__fini_array_start;
	while (f != &__fini_array_end) {
		(*f)();
		f++;
	}
}


#define  RCC_CR     *((uint32_t *) 0x40021000)
#define  RCC_CFGR   *((uint32_t *) 0x40021004)
#define  FLASH_ACR  *((uint32_t *) 0x40022000)


void _initClock() {
	// configure flash wait states (two wait states for 72 MHz)
	FLASH_ACR = 0x12;
	// configure pll: 8 --> 72 MHz
	// external clock, not divided by 2, x9 --> 72 MHz, usb clock = 72 / 1.5 = 48 MHz
	// adc prescaler /6, apb2 prescaler /1, apb1 prescaler /2, ahb prescaler /1
	RCC_CFGR = (((uint32_t) 1) << 16) | (((uint32_t) 7) << 18) | (((uint32_t) 2) << 14) | (((uint32_t) 4) << 8);
	// enable hse (external clock)
	RCC_CR = ((uint32_t) 1) << 16;
	// wait for hse to be ready
	while ((RCC_CR & (((uint32_t) 1) << 17)) == 0)
		;
	// enable pll
	RCC_CR |= ((uint32_t) 1) << 24;
	// wait for pll to be locked
	while ((RCC_CR & (((uint32_t) 1) << 25)) == 0)
		;
	// when pll locked, the select that clock as system clock
	RCC_CFGR &= ~((uint32_t) 3);
	RCC_CFGR |= 2;
	// wait until system clock selected
	while (((RCC_CFGR >> 2) & 3) != 2)
		;
}


extern int main();


extern "C" {
	extern unsigned char flash_sdata;
	extern unsigned char ram_sdata;
	extern unsigned char ram_edata;
}


void _initDataRAM() {
	// init .data section (global variables) with flash data
	unsigned char *from = &flash_sdata;
	unsigned char *to = &ram_sdata;
	while (to != &ram_edata) {
		*to = *from;
		from++;
		to++;
	}
}


extern "C" {
	extern unsigned char ram_sbssdata;
	extern unsigned char ram_ebssdata;
}


void _initBssRAM() {
	// init .bss section with zeros
	unsigned char *p = &ram_sbssdata;
	while (p != &ram_ebssdata) {
		*p = 0;
		p++;
	}
}


void _startup() __attribute__((section(".startup"), naked));


void _startup() {
	_initClock();
	_initDataRAM();
	_initBssRAM();
	_callConstructors();
	_callInitArray();
	main();
	_callFiniArray();
	_callDestructors();
	while (true)
		;
}

extern "C" void __cxa_pure_virtual() {}
void *__dso_handle = 0;
extern "C" void __cxa_atexit() {}

