SECTIONS {
	. = 0x00000000 ;
	.cortex_m3_vectors : {
		LONG(0x20005000);
		LONG(0x0000013D);
	}
	. = 0x0000003C ;
	.cortex_m3_vector_systick : {
		LONG(SYSTICK_ADDRESS + 1);
	}
	. = 0x00000090 ;
	.cortex_m3_vector_usblp : {
		LONG(USBLP_ADDRESS + 1);
	}
	. = 0x000000D4 ;
	.cortex_m3_vector_usart1 : {
		LONG(USART1_ADDRESS + 1);
	}
	. = 0x0000013C ;
	.text : {
		_linker_code = . ;
		startup.o (.startup)
		*(.text)
		*(.text.*)
		*(.rodata*)
		*(.gnu.linkonce.t*)
		*(.gnu.linkonce.r*)
	}
	SYSTICK_ADDRESS = . ;
	.systick : {
		*(.systick)
	}
	USBLP_ADDRESS = . ;
	.usblp : {
		*(.usblp)
	}
	USART1_ADDRESS = . ;
	.usart1 : {
		*(.usart1)
	}
	.preinit_array : {
		__preinit_array_start = . ;
		*(.preinit_array)
		__preinit_array_end = . ;
	}
	.init_array : {
		__init_array_start = . ;
		*(.init_array)
		__init_array_end = . ;
	}
	.fini_array : {
		__fini_array_start = . ;
		*(.fini_array)
		__fini_array_end = . ;
	}
	.ctors : {
		__CTOR_LIST__ = . ;
		LONG((__CTOR_END__ - __CTOR_LIST__) / 4 - 2)
		*(.ctors)
		LONG(0)
		__CTOR_END__ = . ;
	}
	.dtors : {
		__DTOR_LIST__ = . ;
		LONG((__DTOR_END__ - __DTOR_LIST__) / 4 - 2)
		*(.dtors)
		LONG(0)
		__DTOR_END__ = . ;
	}
	flash_sdata = . ;
	. = 0x20000000 ;
	ram_sdata = . ;
	.data : AT (flash_sdata) {
		_linker_data = . ;
		*(.data)
		*(.data.*)
		*(.gnu.linkonce.d*)
	}
	ram_edata = . ;
	data_size = ram_edata - ram_sdata;
	ram_sbssdata = . ;
	.bss : AT (LOADADDR(.data) + SIZEOF(.data)) {
		_linker_bss = . ;
		*(.bss)
		*(.bss.*)
		*(.gnu.linkonce.b.*)
		*(.COMMON)
	}
	ram_ebssdata = . ;
	bssdata_size = ram_ebssdata - ram_sbssdata;
	_linker_end = . ;
	end = . ;
}
